<?php
function getHttpCode($url, $followLocation = false, $maxRedirects = 10, &$lastUrl = '')
{
    // Options
    $curlOptions = [
        CURLOPT_HEADER => true,
        CURLOPT_NOBODY => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_CONNECTTIMEOUT => 10,
    ];

    if ($followLocation) {
        $curlOptions[CURLOPT_FOLLOWLOCATION] = true;
        $curlOptions[CURLOPT_MAXREDIRS] = $maxRedirects;
    }

    // Initialization
    $ch = curl_init($url);

    // Set options
    curl_setopt_array($ch, $curlOptions);

    // Execute request
    curl_exec($ch);

    // Get HTTP code
    $result = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Get last URL
    $lastUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);

    // Close the resource
    curl_close($ch);

    return (int) $result;
}
print_r(getHttpCode('https://www.google.com'));

/**
[output]
200
 */